#include <cstdio>
#include <algorithm>
#include <vector>
#include <utility>

using namespace std;

const int MAXN = 1010;

int n, m, k;
int a[MAXN][MAXN], dp[MAXN][MAXN];
int maxs[MAXN * MAXN];

int main() {
  scanf("%d%d%d", &n, &m, &k);
  vector<pair<int, int>> o;
  for (int i = 0; i < n; ++i) {
    for (int j = 0; j < m; ++j) {
      scanf("%d", &a[i][j]);
      o.emplace_back(i, j);
    }
  }

  sort(o.begin(), o.end(), [&](pair<int, int> x, pair<int, int> y) {
      return a[x.first][x.second] < a[y.first][y.second];
  });
  reverse(o.begin(), o.end());

  for (auto t : o) {
    int &ref = dp[t.first][t.second];
    int h = a[t.first][t.second];
    ref = 1;
    const int dx[] = {-1, 1, 0, 0};
    const int dy[] = {0, 0, -1, 1};
    for (int i = 0; i < 4; ++i) {
      int ny = t.first + dy[i];
      int nx = t.second + dx[i];
      if (ny < 0 || ny >= n || nx < 0 || nx >= m || h >= a[ny][nx]) continue;
      ref = max(ref, dp[ny][nx] + 1);
    }
    maxs[h] = max(maxs[h], ref);
  }

  vector<int> sol;
  int curr_max = 0;
  for (int i = MAXN * MAXN - 1; i >= 1; --i) {
    curr_max = max(curr_max, maxs[i]);
    sol.push_back(curr_max);
  }
  reverse(sol.begin(), sol.end());
  sol.resize(k);
  for (int x : sol) {
    printf("%d\n", x);
  }
  return 0;
}
